TITLE   'Simple Magnet Coil' 					{ exa132.pde }
SELECT     errlim=3e-4     ngrid=1     spectral_colors	
COORDINATES   ycylinder( 'r', 'z')				{ Student Version }
VARIABLES   A_phi
DEFINITIONS
   r1=0.1     r2=0.2     z0=0.2     L=1.0
   mu0=4*pi*1e-7     mu=mu0     J_phi
   Br=-dz(A_phi)     Bz=1/r*dr(r*A_phi)
   B=vector( Br, Bz)     Bm=magnitude( B)
   Hr=Br/mu     Hz=Bz/mu     H=B/mu     Hm=Bm/mu
EQUATIONS
   dz( Hr)- dr( Hz)=J_phi
BOUNDARIES
region 'domain' J_phi=0					
   start(0,-L) value(A_phi)=0 line to (2*L,-L) to (2*L,L)  to (0,L) close
region 'coil'  J_phi=1.0            				{ Current density }
   start(r1,-z0)  line to (r2,-z0) to (r2,z0) to (r1,z0) close
PLOTS
   contour( Bm) log     vector( B) norm
   contour( Bm) painted zoom(0,-2*z0,  4*z0,4*z0)
   vector( B) norm zoom(0,-2*z0,  4*z0,4*z0)
END	




